* This file contains the primary analysis of the WVS macro data
use "Processed files\WVS_macro", clear

*** Table 1
use "Processed files\WVS_macro" if nonrepresentative==0, clear

* All countries
bys wave: reg sat_hat lgdp, robust
xi: reg sat_hat lgdp i.wave, robust cluster(cty)

bys wave: reg hap_hat lgdp, robust
xi: reg hap_hat lgdp i.wave, robust cluster(cty)

* Rich countries
bys wave: reg sat_hat lgdp if gdp>15000, robust
xi: reg sat_hat lgdp i.wave if gdp>15000, robust cluster(cty)

bys wave: reg hap_hat lgdp if gdp>15000, robust
xi: reg hap_hat lgdp i.wave if gdp>15000, robust cluster(cty)

* Poor countries
bys wave: reg sat_hat lgdp if gdp<15000, robust
xi: reg sat_hat lgdp i.wave if gdp<15000, robust cluster(cty)

bys wave: reg hap_hat lgdp if gdp<15000, robust
xi: reg hap_hat lgdp i.wave if gdp<15000, robust cluster(cty)

* Are rich different from poor?
gen rich=gdp>=15000 if gdp~=.
gen richXlgdp=rich*lgdp
bys wave: reg sat_hat lgdp rich richXlgdp, robust
xi: reg sat_hat lgdp rich richXlgdp i.wave, robust cluster(cty)
bys wave: reg hap_hat lgdp rich richXlgdp, robust
xi: reg hap_hat lgdp rich richXlgdp i.wave, robust cluster(cty)

* Are there important wave-specific differences?
xi: reg sat_hat i.wave*lgdp, robust cluster(cty)
testparm _IwavX*

*** Table 3
use "Processed files\WVS_macro" if nonrepresentative==0, clear
egen cty_id=group(cty)

reg sat_hat lgdp, robust cluster(cty)
xi: reg sat_hat lgdp i.cty, robust cluster(cty) 
xi: reg sat_hat lgdp i.cty i.wave, robust cluster(cty)
egen t_sat=rank(wave) if lgdp~=. & sat_hat~=., by(cty)
tsset cty_id t_sat
reg d.sat_hat d.lgdp if t_sat~=., robust cluster(cty)
egen minwv_sat=min(wave) if lgdp~=. & sat_hat~=., by(cty)
egen maxwv_sat=max(wave) if lgdp~=. & sat_hat~=., by(cty)
egen d_sat=rank(t_sat) if (wave==minwv_sat | wave==maxwv_sat) & (minwv~=maxwv), by(cty)
tsset cty_id d_sat
reg d.sat_hat d.lgdp if d_sat~=., robust cluster(cty)
drop t_sat d_sat minwv maxwv

reg hap_hat lgdp, robust cluster(cty)
xi: reg hap_hat lgdp i.cty , robust cluster(cty)
xi: reg hap_hat lgdp i.cty i.wave, robust cluster(cty)
egen t_hap=rank(wave) if lgdp~=. & hap_hat~=., by(cty)
tsset cty_id t_hap
reg d.hap_hat d.lgdp if t_hap~=., robust cluster(cty)
egen minwv_hap=min(wave) if lgdp~=. & hap_hat~=., by(cty)
egen maxwv_hap=max(wave) if lgdp~=. & hap_hat~=., by(cty)
egen d_hap=rank(t_hap) if (wave==minwv_hap| wave==maxwv_hap) & (minwv~=maxwv), by(cty)
tsset cty_id d_hap
reg d.hap_hat d.lgdp if d_hap~=., robust cluster(cty)
drop t_hap d_hap minwv maxwv



*** Figure 2
use "Processed files\WVS_macro", clear
levelsof wave, local(waves)
foreach w of local waves {
	local lb: label waves `w'
	correl sat_hat lgdp if wave==`w' & nonrepresentative==0
	local rho=string(r(rho),"%3.2f")
	reg sat_hat lgdp if wave==`w' & nonrepresentative==0, robust
	predict sat_hat_fit
	local b=string(_b[lgdp],"%3.2f")
	local a=string(_b[_cons],"%3.2f")
	local se=string(_se[lgdp],"%3.2f")
	lowess sat_hat lgdp if wave==`w' & nonrepresentative==0, nograph generate(sat_hat_low)
	#delimit ;
	twoway
		(scatter sat_hat gdp if nonrepresentative==0, mlabel(cty) mcolor(navy) mlabcolor(navy))
		(scatter sat_hat gdp if nonrepresentative>0, symbol(square_hollow) mlabel(cty) mcolor(black) mlabcolor(black))
		(line sat_hat_low gdp, sort lpattern(dot) lcolor(cranberry))
		(line sat_hat_fit gdp, sort lpattern(longdash) lcolor(black))
		if wave==`w'
	,
		xscale(log)
		xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
		xtitle("")
		ylabel(-1.5(.5)1.5, angle(horizontal) format(%9.1f))
		title("`lb'", ring(0) span)
		legend(off)
		note("y = `a'+`b'*ln(x) [se=`se']" "Correlation=`rho'", ring(0) pos(5))
		xsize(10) ysize(7.5)
		name(Xcountry_`w', replace)
	;
	#delimit cr		
	drop sat_hat_fit sat_hat_low
}

#delimit ;
graph combine Xcountry_1982 Xcountry_1990 Xcountry_1996 Xcountry_2000,
	ycommon
	imargin(tiny)
	l1title("Life satisfaction (ordered probit index)", size(small))
	b1title("Real GDP per Capita (thousands of dollars, log scale)", size(small))
	xsize(10) ysize(7.5)
	name(satgdp, replace)
;
#delimit cr
graph save "Figures/fig2.gph", replace

*** Figure 5: Happiness v. Life Satisfaction
use "Processed files\WVS_macro", clear
la var hap_hat "Happiness"
la var sat_hat "Life Satisfaction"
foreach v of varlist hap_hat sat_hat {
	local lb: variable label `v'
	correl `v' lgdp  if wave==2000  & nonrepresentative==0
	local rho=string(r(rho),"%3.2f")
	reg `v' lgdp  if wave==2000  & nonrepresentative==0
	predict `v'_fit
	local b=string(_b[lgdp],"%3.2f")
	local a=string(_b[_cons],"%3.2f")
	local se=string(_se[lgdp],"%3.2f")
	correl `v' lgdp if  wave==2000 & cty~="NGA" & cty~="TZA" & nonrepresentative==0
	local rhox=string(r(rho),"%3.2f")
	reg `v' lgdp if wave==2000 &  cty~="NGA" & cty~="TZA" & nonrepresentative==0, robust
	predict `v'_fitx
	local bx=string(_b[lgdp],"%3.2f")
	local ax=string(_b[_cons],"%3.2f")
	local sex=string(_se[lgdp],"%3.2f")

	lowess `v' lgdp if wave==2000 & nonrepresentative==0, nograph generate(`v'_low)
	#delimit ;
	twoway
		(scatter `v' gdp if  wave==2000 &  cty~="TZA" & cty~="NGA" & nonrepresentative==0, mlabel(cty) mcolor(navy) mlabcolor(navy) msymbol(circle)  )
		(scatter `v' gdp if  wave==2000 &  cty~="TZA" & cty~="NGA" & nonrepresentative>0, mlabel(cty) mcolor(black) mlabcolor(black) msymbol(square_hollow)  )
		(scatter `v' gdp if  wave==2000 &  cty=="TZA" | cty=="NGA", mlabel(cty) msymbol(triangle) mcolor(green) mlabcolor(green))
		(line `v'_low gdp, sort lpattern(dot) lcolor(cranberry))
		(line `v'_fit gdp, sort lpattern(longdash) lcolor(black))
		if wave==2000 
	,
		xscale(log)
		xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
		xtitle("")
		ylabel(-1.5(.5)1.5, angle(horizontal) format(%9.1f))
		title("`lb'", ring(0))
		legend(off)
		note("y = `a'+`b'*ln(x) [se=`se']" "Correlation=`rho'" "Excluding NGA and TZA: y = `ax'+`bx'*ln(x) [se=`sex']" "Correlation=`rhox'" , ring(0) pos(5))
		xsize(10) ysize(7.5)
		name(measure_`v', replace)
	;
	#delimit cr		
	drop *_fit *_low
}

#delimit ;
graph combine measure_sat_hat measure_hap_hat,
	ycommon
	imargin(tiny)
	rows(2)
	l1title("Ordered probit index", size(small))
	b1title("Real GDP per Capita, (thousands of dollars, log scale)", size(small))
	xsize(7.5) ysize(10)
	name(hapvsat, replace)
;
#delimit cr
graph save "Figures/fig5.gph", replace



*** Figure 14: Changes through time
use "Processed files\WVS_macro", clear

* Satisfaction
reg sat_hat lgdp if nonrepresentative==0
predict sat_hathat
egen w=rank(wave) if sat_hat~=., by(cty)
drop if w==.
egen ctyid=group(cty)
tsset ctyid w
gen s_dgdp=sign(d.gdp)
gen s_dsat=sign(d.sat_hat)
tab s_dgdp s_dsat
tab s_dgdp s_dsat if nonrepresentative==l.nonrepresentative
replace sat_hat=sat_hat+.1 if wave>1990
replace s_dsat=sign(d.sat_hat) if wave>1990
tab s_dgdp s_dsat if nonrepresentative==l.nonrepresentative
replace sat_hat=sat_hat-.1 if wave>1990

drop cgdp hap_hat lgdp feeling_* s_dgdp s_dsat
reshape wide gdp mld sat_hat sat_hathat nonrep wave, i(cty) j(w)
for X in num 1/4: gen str4 wave_strX=string(waveX) \ gen str2 wvX=substr(wave_strX,-2,2)

#delimit ;
twoway
	(line sat_hathat1 gdp1, sort lpattern(longdash) lcolor(black) lwidth(vvthin))
	(pcarrow sat_hat1 gdp1  sat_hat2 gdp2  if sat_hat2~=. & nonrepresentative1==nonrepresentative2, mlabel(cty) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(thin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow sat_hat2 gdp2  sat_hat3 gdp3  if sat_hat3~=. & nonrepresentative2==nonrepresentative3,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(thin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow sat_hat3 gdp3  sat_hat4 gdp4  if sat_hat4~=. & nonrepresentative3==nonrepresentative4,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(thin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))

	(pcarrow sat_hat1 gdp1  sat_hat2 gdp2  if sat_hat2~=. & nonrepresentative1!=nonrepresentative2, mlabel(cty)  mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow sat_hat2 gdp2  sat_hat3 gdp3  if sat_hat3~=. & nonrepresentative2!=nonrepresentative3,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow sat_hat3 gdp3  sat_hat4 gdp4  if sat_hat4~=. & nonrepresentative3!=nonrepresentative4,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))

	(scatter sat_hat1 gdp1 if sat_hat2~=., msymbol(point) mlabel(wv1) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter sat_hat2 gdp2 if sat_hat2~=., msymbol(point) mlabel(wv2) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter sat_hat3 gdp3 if sat_hat3~=., msymbol(point) mlabel(wv3) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter sat_hat4 gdp4 if sat_hat4~=., msymbol(point) mlabel(wv4) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
,
	xscale(log)
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	legend(off)
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%9.1f) nolabel)
	title("Life Satisfaction", ring(0))
	xsize(10) ysize(7.5)
	name(g_gdpsat2, replace)
;
#delimit cr

* Happiness
use "Processed files\WVS_macro", clear
reg hap_hat lgdp if nonrepresentative==0
predict hap_hathat
egen w=rank(wave) if hap_hat~=., by(cty)
drop if w==.
egen ctyid=group(cty)
tsset ctyid w
gen s_dgdp=sign(d.gdp)
gen s_dhap=sign(d.hap_hat)
tab s_dgdp s_dhap
tab s_dgdp s_dhap if nonrepresentative==l.nonrepresentative
replace hap_hat=hap_hat-.15 if wave>1990
replace s_dhap=sign(d.hap_hat) if wave>1990
tab s_dgdp s_dhap if nonrepresentative==l.nonrepresentative
replace hap_hat=hap_hat-.1 if wave>1990


drop cgdp sat_hat lgdp mld feeling_* s_dgdp s_dhap
reshape wide gdp hap_hat hap_hathat nonrep  wave, i(cty) j(w)
for X in num 1/4: gen str4 wave_strX=string(waveX) \ gen str2 wvX=substr(wave_strX,-2,2)
#delimit ;
twoway
	(line hap_hathat1 gdp1, sort lpattern(longdash) lcolor(black) lwidth(vvvthin))
	(pcarrow hap_hat1 gdp1  hap_hat2 gdp2  if hap_hat2~=. & nonrepresentative1==nonrepresentative2, mlabel(cty) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(vthin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow hap_hat2 gdp2  hap_hat3 gdp3  if hap_hat3~=. & nonrepresentative2==nonrepresentative3,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(thin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow hap_hat3 gdp3  hap_hat4 gdp4  if hap_hat4~=. & nonrepresentative3==nonrepresentative4,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(navy) lwidth(thin) mlwidth(thin) mcolor(navy) mfcolor(navy) mlcolor(navy))

	(pcarrow hap_hat1 gdp1  hap_hat2 gdp2  if hap_hat2~=. & nonrepresentative1!=nonrepresentative2, mlabel(cty)  mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow hap_hat2 gdp2  hap_hat3 gdp3  if hap_hat3~=. & nonrepresentative2!=nonrepresentative3,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))
	(pcarrow hap_hat3 gdp3  hap_hat4 gdp4  if hap_hat4~=. & nonrepresentative3!=nonrepresentative4,  mlabel(   ) mlabsize(tiny) mlabcolor(black) mlabpos(6) mlabgap(.1) lcolor(green) lpattern(dot) lwidth(vthin) mlwidth(vthin) mcolor(navy) mfcolor(navy) mlcolor(navy))

	(scatter hap_hat1 gdp1 if hap_hat2~=., msymbol(point) mlabel(wv1) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter hap_hat2 gdp2 if hap_hat2~=., msymbol(point) mlabel(wv2) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter hap_hat3 gdp3 if hap_hat3~=., msymbol(point) mlabel(wv3) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
	(scatter hap_hat4 gdp4 if hap_hat4~=., msymbol(point) mlabel(wv4) mlabsize(tiny) mlabcolor(gray) mlabpos(0) mlabgap(.1))
,
	xscale(log)
	xlabel( 500 ".5" 1000 "1"   2000 "2" 4000 "4" 8000 "8" 16000 "16" 32000 "32") 
	legend(off)
	ylabel(-1.5(.5)1.5, angle(horizontal) format(%9.1f))
	title("Happiness", ring(0))
	xsize(10) ysize(7.5)
	name(g_gdphap2, replace)
;
#delimit cr

#delimit ;
graph combine g_gdphap2 g_gdpsat2,
	l1title("Ordered probit index", size(small))
	b1title("Real GDP per capita (thousands of dollars, log scale)", size(small))
	imargin(tiny)
	cols(2) rows(1)
	ycommon
	xsize(10) ysize(7.5)
	name(evolution, replace)
;
#delimit cr
graph save "Figures/fig14.gph", replace


*** Figure 15: First Differences
use "Processed files/WVS_macro" if sat_hat~=. & lgdp~=., clear
keep cty wave sat_hat lgdp nonrepresentative
reshape wide sat_hat lgdp nonrep, i(cty) j(wave)

foreach v of numlist 1982 1990 1996 2000 {
	foreach w of numlist 1990 1996 2000 {
		if `w'>`v' {
			gen ds_`v'_`w'=sat_hat`w'-sat_hat`v'
			gen dy_`v'_`w'=exp(lgdp`w')/exp(lgdp`v')-1
			reg ds_`v'_`w' dy_`v'_`w' if nonrepresentative`v'==nonrepresentative`w'
			predict ds_`v'_`w'_hat
			global c_`v'_`w'=string(_b[_cons], "%4.2f")
			global b_`v'_`w'=string(_b[dy], "%4.2f")
			global se_`v'_`w'=string(_se[dy], "%4.2f")
			correl ds_`v'_`w' dy_`v'_`w'
			global rho_`v'_`w'=string(r(rho), "%4.2f")
		}
	}
}

for var dy*: replace X=X*100

#delimit ;
twoway
	(scatter ds_1982_1990 dy_1982_1990 if nonrepresentative1982==nonrepresentative1990, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1982_1990 dy_1982_1990 if nonrepresentative1982!=nonrepresentative1990, mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1982_1990_hat dy_1982_1990, sort lpattern(dash) lcolor(black))
,
	title("Changes between waves I and II", ring(0) size(small))

	text(.65 25	"Ch. Sat.=$c_1982_1990+$b_1982_1990*Ch. GDP [se=$se_1982_1990]",	size(small)	)
	legend(off)
	xtitle("")
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f))
	ytitle("")
	xlabel(-50(50)100, format(%4.0f))
	xsize(10) ysize(7.5)
	name(ch_1982_1990, replace)
;

#delimit ;
twoway
	(scatter ds_1990_1996 dy_1990_1996 if nonrepresentative1990==nonrepresentative1996, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1990_1996 dy_1990_1996 if nonrepresentative1990!=nonrepresentative1996, mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1990_1996_hat dy_1990_1996, sort lpattern(dash) lcolor(black))
,
	title("Changes between waves II and III", ring(0) size(small))
	text(.65 25	"Ch. Sat.=$c_1990_1996+$b_1990_1996*Ch. GDP [se=$se_1990_1996]",	size(small)	)

	legend(off)
	xtitle("")
	xlabel(-50(50)100, format(%4.0f))
	ytitle("")
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f) nolabel)
	xsize(10) ysize(7.5)
	name(ch_1990_1996, replace)
;


#delimit ;
twoway
	(scatter ds_1996_2000 dy_1996_2000 if nonrepresentative1996==nonrepresentative2000, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1996_2000 dy_1996_2000 if nonrepresentative1996!=nonrepresentative2000, mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1996_2000_hat dy_1996_2000, sort lpattern(dash) lcolor(black))
,
	title("Changes between waves III and IV", ring(0) size(small))
	text(.65 25	"Ch. Sat.=$c_1996_2000+$b_1996_2000*Ch. GDP [se=$se_1996_2000]",	size(small)	)

	legend(off)
	xtitle("")
	xlabel(-50(50)100, format(%4.0f))
	ytitle("")
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f) nolabel)
	xsize(10) ysize(7.5)
	name(ch_1996_2000, replace)
;

#delimit ;
twoway
	(scatter ds_1982_1996 dy_1982_1996 if nonrepresentative1982==nonrepresentative1996, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1982_1996 dy_1982_1996 if nonrepresentative1982!=nonrepresentative1996, mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1982_1996_hat dy_1982_1996, sort lpattern(dash) lcolor(black))
,
	title("Changes between waves I and III", ring(0) size(small))
	text(.65 25	"Ch. Sat.=$c_1982_1996+$b_1982_1996*Ch. GDP [se=$se_1982_1996]",	size(small)	)

	legend(off)
	xtitle("")
	xlabel(-50(50)100, format(%4.0f))
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f))
	ytitle("")
	xsize(10) ysize(7.5)
	name(ch_1982_1996, replace)
;

#delimit cr
summ dy_1990_2000 if cty=="CHN"
local dy_chn=string(r(mean), "%4.0f")
summ ds_1990_2000 if cty=="CHN"
local dh_chn=string(r(mean), "%4.2f")
local dh_chn_lab=`dh_chn'-.1
gen dy_chn=100

#delimit ;
twoway
	(scatter ds_1990_2000 dy_1990_2000 if nonrepresentative1990==nonrepresentative2000, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1990_2000 dy_1990_2000 if cty~="CHN" & (nonrepresentative1990!=nonrepresentative2000), mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(scatter ds_1990_2000 dy_chn if cty=="CHN" , msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1990_2000_hat dy_1990_2000 if dy_1990_2000<100, sort lpattern(dash) lcolor(black))
	
,
	title("Changes between waves II and IV", ring(0) size(small))
	text(.65 25	"Ch. Sat.=$c_1990_2000 +$b_1990_2000*Ch. GDP [se=$se_1990_2000]",	size(small)	)

	text(`dh_chn_lab' 90 "CHN Offscale" "(`dy_chn', `dh_chn')", size(vsmall) justification(left))
	legend(off)
	xtitle("")
	xlabel(-50(50)100, format(%4.0f))
	ytitle("")
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f) nolabel)
	xsize(10) ysize(7.5)
	name(ch_1990_2000, replace)
;

#delimit cr
gen dy_kor=150
summ dy_1982_2000 if cty=="KOR"
local dy_kor=string(r(mean), "%4.0f")
summ ds_1982_2000 if cty=="KOR"
local dh_kor=string(r(mean), "%4.2f")
local dh_kor_lab=`dh_kor'-.05


#delimit ;
twoway
	(scatter ds_1982_2000 dy_1982_2000 if cty~="KOR" & nonrepresentative1982==nonrepresentative2000, mlabel(cty) msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1982_2000 dy_kor if cty=="KOR" , msymbol(circle) mcolor(navy) mlabcolor(navy))
	(scatter ds_1982_2000 dy_1982_2000 if nonrepresentative1982!=nonrepresentative2000, mlabel(cty) msymbol(square_hollow) mcolor(black) mlabcolor(black))
	(line ds_1982_2000_hat dy_1982_2000 if dy_1982_2000<150, sort lpattern(dash) lcolor(black))
,
	title("Changes between waves I and IV", ring(0) size(small))
	text(.65 75	"Ch. Sat.=$c_1982_2000 +$b_1982_2000*Ch. GDP [se=$se_1982_2000]",	size(small)	)
	text(`dh_kor_lab' 140 "KOR Offscale" "(`dy_kor', `dh_kor')", size(vsmall) justification(left))
	legend(off)
	xtitle("")
	xlabel(0(50)150, format(%4.0f))
	ytitle("")
	ylabel(-.5(.25).75, angle(horizontal) format(%4.2f) nolabel)
	xsize(10) ysize(7.5)
	name(ch_1982_2000, replace)
;


#delimit ;
graph combine ch_1982_1990 ch_1990_1996 ch_1996_2000 ch_1982_1996 ch_1990_2000 ch_1982_2000,
	cols(3) imargin(tiny)
	l1title("Cumulative change in life satisfaction (ordered probit index)", size(small))
	b1title("Cumulative change in real GDP per capita (percent)", size(small))
	xsize(10) ysize(7.5)
	name(change_sat, replace)
;
#delimit cr		
graph save "Figures/fig15.gph", replace


*** Figure 21: Feelings
use "Processed files\wvs_macro", clear
local q "We are interested in the way people are feeling these days.  During the past few weeks, did you ever feel..."

for ! in any one two three \ @ in any " " "Pleased about having" "accomplished something": char feeling_pleased[!] "@" 
for ! in any one two three \ @ in any "Proud because someone" "complimented you on" "something you had done": char feeling_proud[!] "@" 
for ! in any one two three \ @ in any " " "Particularly excited or" "interested in something" : char feeling_excited[!] "@" 
for ! in any one two three \ @ in any " " "On top of the world /" "feeling that life is wonderful": char feeling_topoftheworld[!] "@" 
for ! in any one two three \ @ in any " " "That things were" "going your way" : char feeling_goingmyway[!] "@" 
for ! in any one two three \ @ in any " " " " "Bored": char feeling_bored[!] "@" 
for ! in any one two three \ @ in any " " "Upset because somebody" "criticized you": char feeling_upset[!] "@" 
for ! in any one two three \ @ in any " " "So restless you couldn't" "long in a chair" : char feeling_restless[!] "@" 
for ! in any one two three \ @ in any " " "Very lonely or" "remote from other people" : char feeling_lonely[!] "@" 
for ! in any one two three \ @ in any " " " " "Depressed or unhappy" : char feeling_depressed[!] "@" 

la var feeling_excited "Particularly excited or interested in something"
la var feeling_restless "So restless you couldn't sit long in a chair"
la var feeling_proud "Proud b/c someone complimented you on something you had done"
la var feeling_lonely "Very lonely or remote from other people"
la var feeling_pleased "Pleased about having accomplished something"
la var feeling_bored "Bored"
la var feeling_topoftheworld "On top of the world/ feeling that life is wonderful"
la var feeling_depressed "Depressed or unhappy"
la var feeling_goingmyway "That things were going your way"
la var feeling_upset "Upset because somebody criticized you"

global feelings ""

foreach v of varlist feeling_pleased feeling_proud feeling_excited feeling_topof feeling_goingmyway feeling_bored feeling_upset feeling_restless feeling_lonely feeling_depressed  {
	local noy="nolabel"
	if "`v'"=="feeling_pleased_hat" | "`v'"=="feeling_bored_hat" {
		local noy=""
	}
	global feelings $feelings `v'
	replace `v'=`v'*100
	reg `v' lgdp
	predict `v'_fit
	local b=_b[lgdp]
	local se=string(round(_se[lgdp],.001),"%4.1f")
	local t=string(round(`b'/`se',.01),"%4.2f")
	local b=string(round(`b',.001),"%4.1f")
	local a=string(round(_b[_cons],.001),"%4.1f")
	correl `v' lgdp
	local rho=string(round(r(rho),.01),"%3.2f")
	local lb1: char `v'[one]
	local lb2: char `v'[two]
	local lb3: char `v'[three]
	lowess `v' lgdp, nograph generate(`v'_low)
	#delimit ;
	twoway
		(scatter `v' gdp, mlabpos(0) msymbol(circle) mcolor(navy))
		(line `v'_low gdp, sort lpattern(dot) lcolor(cranberry))
		(line `v'_fit gdp, sort lpattern(longdash) lcolor(black))
	,
		title("`lb1'" "`lb2'" "`lb3'",
			size(medsmall) span
		)
		note(	"Correlation = `rho'"
			"y=`a'+`b'*ln(x) [se=`se']",
			ring(0) size(small)
		)
		xtick(500 1000 2000 4000 8000 16000 32000)
		xlabel(500 ".5" 2000 "2" 8000 "8" 32000 "32")
		xtitle("")
		ytitle("")
		xscale(log)
		legend(off)
		ylabel(0(20)100, angle(horizontal) `noy')
		xsize(10) ysize(7.5)
		name(`v', replace)
	;
	#delimit cr
	local lb1=""
	local lb2=""
}


#delimit ;
graph combine $feelings,
	imargin(zero)
	ycommon
	rows(2)
	cols(5)
	b1title("Real GDP per capita, (thousands of dollars, log scale)", size(small))
	l1title("Percent reporting indicated feeling", size(small))
	xsize(10) ysize(7.5)
	name(wvs_feelings, replace)
;
#delimit cr
graph save "Figures/fig21.gph", replace


